/*
* Copyright (C) 2008  Intel Corporation
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License, version 2.1, as published by the Free Software Foundation.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#ifdef WIN32
#include <afxwin.h>
#endif
#include <stdio.h>              
#include <stdlib.h>             
#include <stddef.h>             
#include <string.h>             
#include <signal.h>             
#include "AccelApi.h"
#include "DCSApi.h"
#include"TabletApi.h"

#ifndef _WIN32
#define Sleep sleep
#endif

void DCS_ReturnValue_handler(int ret)
{
	switch (ret)
	{
	case DCS_SUCCESS :
		printf("success\n");
		break;
	case DCS_NOT_SUPPORTED :
		printf("request is not supported\n");
		break;
	case DCS_REQUEST_DENIED:
		printf("request is denied\n");
		break;
	case DCS_MODULE_NOTEXIST:
		printf("request module does not exit\n");
		break;
	case DCS_EVENT_NOTEXIST:
		printf("request event does not exit\n");
		break;
	case DCS_FUNC_NOTEXIST:
		printf("request function does not exit\n");
		break;
	case DCS_FAIL_OPERATION:
		printf("operation failed\n");
		break;
	case DCS_CONNECTION_ABORT:
		printf("connection abort\n");
	default:
		break;
	}
}

void CALLBACK  DCS_SystemOrientation_handler (DCS_SystemOrientation *pData)
{
	printf("SystemOrientation data: %d \n", *pData);

#ifndef _WIN32
	system("xrandr --auto");
#endif

	switch (*pData)
	{
	case DCS_SYSTEM_ORIENTATION_NORMAL:
		printf(" DCS_SYSTEM_ORIENTATION_NORMAL\n");

#ifndef _WIN32
		system("xrandr --output LVDS --rotate inverted --output VGA --rotate inverted ");
#endif

		break;

	case DCS_SYSTEM_ORIENTATION_CW90:
		printf(" DCS_SYSTEM_ORIENTATION_CW90\n");

#ifndef _WIN32
		system("xrandr --output LVDS --rotate left --output VGA --rotate left ");
#endif

		break;

	case DCS_SYSTEM_ORIENTATION_CW180:
		printf(" DCS_SYSTEM_ORIENTATION_CW180\n");

#ifndef _WIN32
		system("xrandr --output LVDS --rotate normal --output VGA --rotate normal ");
#endif

		break;

	case DCS_SYSTEM_ORIENTATION_CW270:
		printf(" DCS_SYSTEM_ORIENTATION_CW270\n");

#ifndef _WIN32
		system("xrandr --output LVDS --rotate right --output VGA --rotate right ");
#endif

		break;

	default:
		printf("input system orientation data is %d \n", *pData);
		break;
	}
}

/* Call back function for Tablet Sensor */
void CALLBACK DCS_TabletSensor_handler (DCS_Tablet_Sensor_Data *pData)
{
	if (pData == NULL)
		return;
	printf("tablet data: %d \n", *pData);

	switch (*pData)
	{
	case DCS_CLAMSHELL_MODE:
		printf("DCS_CLAMSHELL_MODE\n");

#ifndef _WIN32
		system("xrandr --auto");
		system("xrandr --output LVDS --rotate normal --output VGA --rotate normal ");
#endif

		DCS_UnregisterSystemOrientationCallback();
		break;

	case DCS_TABLET_MODE:
		printf("DCS_TABLET_MODE\n");

#ifndef _WIN32
		system("xrandr --auto");
		system("xrandr --output LVDS --rotate inverted --output VGA --rotate inverted ");
#endif

		DCS_RegisterSystemOrientationCallback(DCS_SystemOrientation_handler);
		break;

	default:
		printf("input tablet data is %d \n", *pData);
		break;
	}

}

int main(int argc, char *argv[])
{

	int ret = 0;
	int i=0;
	int use_timer=0;
	int enable=0;
	char c0;

	/* Command line parsing */
	for (i=1; i< argc; i++) 
	{
		if (strcmp("-timer", argv[i]) == 0  ) 
		{
			use_timer=1;
		}
	}

	/*initialize the DCS*/
	ret = DCS_Initialize();
	DCS_ReturnValue_handler(ret);

	/* For the Tablet Sensor Interface */
	ret=DCS_RegisterSystemOrientationCallback(DCS_SystemOrientation_handler);
	printf("DCS_RegisterSystemOrientationCallback\n");

	ret=DCS_RegisterTabletSensorCallback(DCS_TabletSensor_handler);
	printf("DCS_RegisterTabletSensorCallback\n");
	DCS_ReturnValue_handler(ret);

	DCS_Tablet_Sensor_Data  Tablet_Sensor_Data;

	ret=DCS_GetTabletSensorMode(&Tablet_Sensor_Data);  

	printf("DCS_GetTabletSensorMode\n");
	DCS_ReturnValue_handler(ret);

	printf("tablet data: %d \n",Tablet_Sensor_Data);

	/*uninitialize the DCS*/
	int count=0;
	int timer=0;

	if(use_timer==0)
	{
		//Sleep(INFINITE);
		while(1)
		    Sleep(10);
	}
	else
	{
		for(timer=0;timer<=50000;timer++)
		{
			count=0;
			
			Sleep(10);
		}
	}

	ret=DCS_UnregisterSystemOrientationCallback();
	printf("DCS_UnregisterSystemOrientationCallback\n");
	DCS_ReturnValue_handler(ret);

	ret=DCS_UnregisterTabletSensorCallback();
	printf("DCS_UnregisterTabletSensorCallback\n");
	DCS_ReturnValue_handler(ret);

	ret=DCS_Uninitialize();
	DCS_ReturnValue_handler(ret);

	return 0;
}

